%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Example of test using "lsqnonlin" function to minimize SE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all
clear

% Initial guess for a local minima
% Io   = 1.608424751803952e-09;
% Iirr = 0.59022933186673;
% Rp   = 6.8324852091985;
% Rs   = 0.10477300556926;
% n    = 1.42095465883443;

% Initial guess for another local minima
% Io   = 1.608424751803952e-06;
% Iirr = 0.58022933186673;
% Rp   = 832.4852091985;
% Rs   = 0.10477300556926;
% n    = 1.2095465883443;

% Initial guess form reduced form 
Io   = 1.608424751803952e-07;
Iirr = 0.579022933186673;
Rp   = 41.668324852091985;
Rs   = 0.160477300556926;
n    = 1.542095465883443;


xo = [Rs n Io Iirr Rp];
options = optimset('MaxFunEvals',150000,'MaxIter',1000,'TolFun',1e-20,'TolX',1e-20,'Algorithm', 'levenberg-marquardt','Display','iter');

[x f1 f2 EXITFLAG OUTPUT] = lsqnonlin(@fitness, xo,[],[], options)

load datatest_bench3.txt;
V=datatest_bench3(:,1);
I=datatest_bench3(:,2);

plot(V,I,'+');
hold on;
plot(V,I-f2','r');