%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Example of test using "lsqnonlin" function to minimize SE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all
clear

% Initial guess for a local minima 
% Io   = 0.00349655846745095e-6;
% Iirr = 0.764114500134348;
% Rp   = 11.103851048129869;
% Rs   = 0.045438486374517;
% n    = 1.134484475006256;

% Initial guess form reduced form 
Io   = 0.2885996958136276e-6;
Iirr = 0.761063439904229;
Rp   = 49.718826727379927;
Rs   = 0.036815752460942;
n    = 1.469531612282979;


xo = [Rs n Io Iirr Rp];
options = optimset('MaxFunEvals',150000,'MaxIter',1000,'TolFun',1e-20,'TolX',1e-20,'Algorithm', 'levenberg-marquardt','Display','iter');

[x f1 f2 EXITFLAG OUTPUT] = lsqnonlin(@fitness, xo,[],[], options)

load datatest_bench2.txt;
V=datatest_bench2(:,1);
I=datatest_bench2(:,2);

plot(V,I,'+');
hold on;
plot(V,I-f2','r');