%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Example of test using "lsqnonlin" function to minimize SE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all
clear

% Initial guess leading to a local minima
% Io   = 3.035366750697098e-9;
% Iirr = 1.0373477407858;
% Rp   = 1.0783516109678138e+2;
% Rs   = 0.818407328046765;
% n    = 1.016752492449578;

% Initial guess leading to a local minima
Io   =   3.035366750697098e-9;
Iirr =   1.073477407858;
Rp   =   0.783516109678138e+5;
Rs   =   1.18407328046765;
n    =   1.33752492449578;

% Initial guess form reduced form 
% Io   =   3.035366750697098e-6;
% Iirr =   1.032173477407858;
% Rp   =   0.783516109678138e+3;
% Rs   =   1.218407328046765;
% n    =   1.336752492449578;


xo = [Rs n Io Iirr Rp];
options = optimset('MaxFunEvals',150000,'MaxIter',1000,'TolFun',1e-20,'TolX',1e-20,'Algorithm', 'levenberg-marquardt','Display','iter');

[x f1 f2 EXITFLAG OUTPUT] = lsqnonlin(@fitness, xo,[],[], options)

load datatest_bench1.txt;
V = datatest_bench1(:,1);
I = datatest_bench1(:,2);

plot(V,I,'+');
hold on;
plot(V,I-f2','r');