%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Generates the I-V curve by using the Lambert funtion W(.) starting from
% the 5 parameters Rs,Rsh,Io,IL,n
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function I=I_bench1(Rs,Rsh,Io,IL,n,T,V)

    k  = 1.3806503E-23;
    q  = 1.602E-19;
    Ns = 36.0;
    VT = k*T/q;

    I = (Rsh*(Io+IL)-V)/(Rsh+Rs)-((Ns*n*VT)/Rs)*lambertw(((Rs*Rsh*Io)/(Ns*n*VT*(Rs+Rsh)))*exp(Rsh*(Rs*(Io+IL)+V)/(Ns*n*VT*(Rs+Rsh))));

